# 🕐💕 راهنمای نصب ربات ساعت‌های جفت

## 🚀 نصب آسان (فقط 3 مرحله!)

### مرحله 1: آپلود فایل‌ها
تمام فایل‌های پوشه `timebot` را روی سرور آپلود کنید.

### مرحله 2: اجرای نصب خودکار
در مرورگر به آدرس زیر بروید:
```
https://yourdomain.com/timebot/install.php
```

فرم نصب را با اطلاعات زیر پر کنید:

#### 🤖 توکن ربات
- از [@BotFather](https://t.me/botfather) در تلگرام دستور `/newbot` بدهید
- نام و username ربات را وارد کنید
- توکن دریافتی را کپی کنید
- فرمت: `123456789:ABCdefGHIjklMNOpqrsTUVwxyz`

#### 🗄️ اطلاعات دیتابیس
از cPanel یا پنل مدیریت هاست:
- **نام دیتابیس**: مثلاً `timebot_db`
- **نام کاربری**: مثلاً `root` یا username دیتابیس
- **رمز عبور**: password دیتابیس
- **آدرس هاست**: معمولاً `localhost`

#### 🌐 آدرس سایت
- آدرس کامل سایت با `https://`
- مثال: `https://yourdomain.com`

### مرحله 3: تنظیم Cron Job
پس از نصب موفق، در cPanel:
1. به بخش **Cron Jobs** بروید
2. **Common Settings** را روی `Every Minute (* * * * *)` بگذارید
3. در قسمت **Command** این دستور را وارد کنید:
```bash
/usr/bin/php /home/username/public_html/timebot/cron.php
```

---

## ✅ بررسی نصب

### تست ربات
1. در تلگرام ربات خود را سرچ کنید
2. دستور `/start` را ارسال کنید
3. باید پیام خوشامد دریافت کنید

### بررسی Webhook
در مرورگر این لینک را باز کنید:
```
https://api.telegram.org/botYOUR_TOKEN/getWebhookInfo
```

باید `url` آدرس `bot.php` شما را نشان دهد.

### تست فایل test.php
```
https://yourdomain.com/timebot/test.php
```

---

## 🔧 عیب‌یابی

### مشکل: نصب خطا می‌دهد
- ✅ مطمئن شوید `curl` در PHP فعال است
- ✅ دسترسی به `api.telegram.org` روی پورت 443 باز باشد
- ✅ توکن ربات صحیح است

### مشکل: Webhook تنظیم نمی‌شود
- ✅ سایت باید HTTPS داشته باشد
- ✅ فایل `bot.php` در مسیر صحیح قرار دارد
- ✅ فایروال سرور اجازه اتصال خروجی می‌دهد

### مشکل: Cron کار نمی‌کند
- ✅ مسیر فایل `cron.php` صحیح است
- ✅ دسترسی اجرای PHP از CLI فعال است
- ✅ در لاگ cPanel خطایی وجود ندارد

---

## 📁 ساختار فایل‌ها

```
timebot/
├── install.php          ⭐ فایل نصب خودکار
├── config.php           📝 تنظیمات (توسط install ساخته می‌شود)
├── bot.php              🤖 مدیریت webhook
├── cron.php             ⏰ ارسال پیام‌های زمان‌بندی
├── database.php         🗄️ مدیریت دیتابیس
├── messages.php         💌 پیام‌های عاشقانه
├── test.php             🧪 تست عملکرد
└── README-INSTALL.md    📖 این فایل
```

---

## ⚠️ نکات امنیتی

1. ✅ بعد از نصب موفق، فایل `install.php` را **حذف** کنید
2. ✅ فایل `config.php` را از دسترسی عمومی محافظت کنید
3. ✅ توکن ربات را در جایی امن نگه دارید
4. ✅ رمز دیتابیس قوی باشد

---

## 📞 پشتیبانی

در صورت بروز مشکل:
1. فایل‌های لاگ را بررسی کنید: `error.log`, `activity.log`, `cron.log`
2. خروجی `test.php` را بررسی کنید
3. با دستور `getWebhookInfo` وضعیت webhook را چک کنید

---

**موفق باشید! 🚀✨**
