<?php
/**
 * نصب دستی بدون Webhook (برای تست محلی یا سرورهای بدون SSL)
 * این روش از getUpdates استفاده می‌کنه به جای webhook
 */

require_once 'config.php';
require_once 'database.php';
require_once 'messages.php';

echo "🤖 ربات تلگرام ساعت‌های جفت - حالت Polling\n";
echo str_repeat("=", 60) . "\n\n";

// حذف webhook
$deleteWebhook = file_get_contents(API_URL . "deleteWebhook");
echo "✅ Webhook حذف شد (در صورت وجود)\n\n";

// آخرین update_id دریافت شده
$lastUpdateId = 0;

echo "✨ ربات شروع به کار کرد! در حال انتظار برای پیام‌ها...\n";
echo "💡 برای توقف: Ctrl+C\n\n";
echo str_repeat("-", 60) . "\n\n";

// حلقه اصلی برای دریافت پیام‌ها
while (true) {
    try {
        // دریافت آپدیت‌های جدید
        $url = API_URL . "getUpdates?offset=" . ($lastUpdateId + 1) . "&timeout=30";
        $response = @file_get_contents($url);
        
        if ($response === false) {
            echo "⚠️  خطا در اتصال به تلگرام\n";
            sleep(5);
            continue;
        }
        
        $data = json_decode($response, true);
        
        if (!isset($data['ok']) || !$data['ok']) {
            echo "❌ خطا: " . ($data['description'] ?? 'نامشخص') . "\n";
            sleep(5);
            continue;
        }
        
        $updates = $data['result'];
        
        foreach ($updates as $update) {
            $lastUpdateId = $update['update_id'];
            
            // پردازش پیام
            if (isset($update['message'])) {
                $message = $update['message'];
                $chat_id = $message['chat']['id'];
                $text = $message['text'] ?? '';
                $first_name = $message['from']['first_name'] ?? 'کاربر';
                
                echo "📩 پیام جدید از $first_name ($chat_id): $text\n";
                
                // پردازش دستورات
                switch ($text) {
                    case '/start':
                        addUser($chat_id, $first_name);
                        
                        $welcomeMessage = "💕 <b>سلام $first_name عزیز!</b> 💕\n\n";
                        $welcomeMessage .= "به ربات ساعت‌های جفت خوش اومدی! 🕐✨\n\n";
                        $welcomeMessage .= "🌟 من هر ساعت جفت (مثل 11:11، 12:12، 01:01 و...) \n";
                        $welcomeMessage .= "یک پیام عاشقانه و خاص برات می‌فرستم که معنی همون ساعته! 💌\n\n";
                        $welcomeMessage .= "✅ الان فعالی و آماده دریافت پیام‌های عاشقانه هستی!\n\n";
                        $welcomeMessage .= "━━━━━━━━━━━━━━━━━━\n";
                        $welcomeMessage .= "🕐 ساعت‌های جفت:\n";
                        $welcomeMessage .= "00:00 | 01:01 | 02:02 | 03:03\n";
                        $welcomeMessage .= "04:04 | 05:05 | 10:10 | 11:11\n";
                        $welcomeMessage .= "12:12 | 13:13 | 14:14 | 15:15\n";
                        $welcomeMessage .= "20:20 | 21:21 | 22:22 | 23:23\n";
                        $welcomeMessage .= "━━━━━━━━━━━━━━━━━━\n\n";
                        $welcomeMessage .= "برای راهنما /help را بزنید";
                        
                        sendMessage($chat_id, $welcomeMessage);
                        echo "✅ پیام خوشامد ارسال شد\n";
                        break;
                        
                    case '/help':
                        $helpMessage = "📖 <b>راهنمای ربات ساعت‌های جفت</b>\n\n";
                        $helpMessage .= "🤖 <b>دستورات:</b>\n";
                        $helpMessage .= "/start - شروع و فعال‌سازی ربات\n";
                        $helpMessage .= "/help - نمایش راهنما\n";
                        $helpMessage .= "/status - وضعیت فعلی\n";
                        $helpMessage .= "/now - دریافت پیام الان\n";
                        $helpMessage .= "/stop - توقف پیام‌ها\n\n";
                        $helpMessage .= "❤️ ساخته شده با عشق!";
                        sendMessage($chat_id, $helpMessage);
                        echo "✅ راهنما ارسال شد\n";
                        break;
                        
                    case '/status':
                        $user = getUser($chat_id);
                        if ($user && $user['active']) {
                            $statusMessage = "✅ <b>وضعیت: فعال</b> 🔔\n\n";
                            $statusMessage .= "شما در حال دریافت پیام‌های ساعت‌های جفت هستید.\n\n";
                            $statusMessage .= "⏰ زمان فعلی: " . date('H:i:s') . "\n";
                            $statusMessage .= "📅 تاریخ: " . date('Y/m/d');
                        } else {
                            $statusMessage = "🔕 <b>وضعیت: غیرفعال</b>\n\n";
                            $statusMessage .= "برای فعال‌سازی دستور /start را ارسال کنید.";
                        }
                        sendMessage($chat_id, $statusMessage);
                        echo "✅ وضعیت ارسال شد\n";
                        break;
                        
                    case '/now':
                        $current_time = date('H:i');
                        $message_text = getMessageForTime($current_time);
                        $message_text = str_replace('{name}', $first_name, $message_text);
                        sendMessage($chat_id, $message_text);
                        echo "✅ پیام لحظه‌ای ارسال شد\n";
                        break;
                        
                    case '/stop':
                        updateUserStatus($chat_id, 0);
                        sendMessage($chat_id, "🔕 پیام‌های ساعت‌های جفت متوقف شد.\n\nبرای فعال‌سازی مجدد /start را بزنید.");
                        echo "✅ کاربر غیرفعال شد\n";
                        break;
                        
                    default:
                        echo "ℹ️  پیام نادیده گرفته شد\n";
                        break;
                }
                
                echo str_repeat("-", 60) . "\n";
            }
        }
        
    } catch (Exception $e) {
        echo "❌ خطا: " . $e->getMessage() . "\n";
        sleep(5);
    }
}

/**
 * ارسال پیام به کاربر
 */
function sendMessage($chat_id, $text, $parse_mode = 'HTML') {
    $url = API_URL . "sendMessage";
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => $parse_mode
    ];
    
    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data)
        ]
    ];
    
    $context  = stream_context_create($options);
    $result = @file_get_contents($url, false, $context);
    
    return $result;
}
