<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب ربات تلگرام ساعت‌های جفت 🕐💕</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 700px;
            margin: 40px auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px;
            text-align: center;
        }
        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        .emoji {
            font-size: 64px;
            margin-bottom: 15px;
        }
        .content {
            padding: 40px;
        }
        .form-group {
            margin-bottom: 25px;
        }
        .form-group label {
            display: block;
            font-weight: 600;
            color: #333;
            margin-bottom: 8px;
            font-size: 14px;
        }
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 15px;
            transition: all 0.3s;
            direction: ltr;
            text-align: left;
        }
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        .form-group small {
            display: block;
            color: #666;
            margin-top: 5px;
            font-size: 12px;
        }
        .btn {
            width: 100%;
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.4);
        }
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
            gap: 10px;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e0e0e0;
            color: #999;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            transition: all 0.3s;
        }
        .step.active {
            background: #667eea;
            color: white;
            transform: scale(1.2);
        }
        .step.completed {
            background: #28a745;
            color: white;
        }
        .divider {
            height: 1px;
            background: #e0e0e0;
            margin: 30px 0;
        }
        .info-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 10px;
            margin: 20px 0;
            border-right: 4px solid #667eea;
        }
        .info-box h4 {
            color: #667eea;
            margin-bottom: 10px;
        }
        .info-box ul {
            margin: 10px 0 10px 20px;
            color: #666;
            line-height: 1.8;
        }
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="emoji">🕐💕</div>
            <h1>نصب ربات ساعت‌های جفت</h1>
            <p>نصب آسان در 3 مرحله</p>
        </div>

        <div class="content">
            <div class="info-box">
                <h4>📋 قبل از شروع:</h4>
                <ul>
                    <li>توکن ربات را از <code>@BotFather</code> در تلگرام دریافت کنید</li>
                    <li>اطلاعات دیتابیس MySQL را از هاست آماده کنید</li>
                    <li>مطمئن شوید دامنه شما HTTPS دارد</li>
                </ul>
            </div>

            <form method="POST" id="installForm">
                <div class="form-group">
                    <label>🤖 توکن ربات تلگرام</label>
                    <input type="text" name="bot_token" required 
                           placeholder="123456789:ABCdefGHIjklMNOpqrsTUVwxyz"
                           pattern="[0-9]+:[A-Za-z0-9_-]+"
                           value="<?php echo $_POST['bot_token'] ?? '8169026930:AAENUxTOiL9hNACSOJMrZfXZ5ZwYLjWjP0c'; ?>">
                    <small>توکنی که از @BotFather دریافت کردید</small>
                </div>

                <div class="divider"></div>

                <div class="form-group">
                    <label>🗄️ نام دیتابیس</label>
                    <input type="text" name="db_name" required 
                           placeholder="timebot_db"
                           value="<?php echo $_POST['db_name'] ?? 'amirtelb_bot'; ?>">
                </div>

                <div class="form-group">
                    <label>👤 نام کاربری دیتابیس</label>
                    <input type="text" name="db_user" required 
                           placeholder="root"
                           value="<?php echo $_POST['db_user'] ?? 'amirtelb_us'; ?>">
                </div>

                <div class="form-group">
                    <label>🔐 رمز عبور دیتابیس</label>
                    <input type="password" name="db_pass" 
                           placeholder="********"
                           value="<?php echo $_POST['db_pass'] ?? 'o9&7oTH;C}J8@?t&'; ?>">
                    <small>اگر رمز ندارید خالی بگذارید</small>
                </div>

                <div class="form-group">
                    <label>🌐 آدرس هاست دیتابیس</label>
                    <input type="text" name="db_host" required 
                           placeholder="localhost"
                           value="<?php echo $_POST['db_host'] ?? 'localhost'; ?>">
                    <small>معمولاً localhost است</small>
                </div>

                <div class="divider"></div>

                <div class="form-group">
                    <label>🔗 آدرس کامل سایت (با https)</label>
                    <input type="url" name="site_url" required 
                           placeholder="https://yourdomain.com"
                           value="<?php echo $_POST['site_url'] ?? 'https://amirtelbot.online/timebot'; ?>">
                    <small>آدرس سایت شما بدون / در انتها</small>
                </div>

                <button type="submit" name="install" class="btn">
                    🚀 شروع نصب
                </button>
            </form>

            <?php
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['install'])) {
                echo '<div class="divider"></div>';
                
                $bot_token = trim($_POST['bot_token']);
                $db_name = trim($_POST['db_name']);
                $db_user = trim($_POST['db_user']);
                $db_pass = $_POST['db_pass'];
                $db_host = trim($_POST['db_host']);
                $site_url = rtrim(trim($_POST['site_url']), '/');
                
                $errors = [];
                $success = [];
                
                // مرحله 1: بررسی توکن
                echo '<div class="alert alert-info">🔍 مرحله 1: بررسی توکن ربات...</div>';
                
                $test_url = "https://api.telegram.org/bot{$bot_token}/getMe";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $test_url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                $response = curl_exec($ch);
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                
                if ($response && $http_code == 200) {
                    $bot_data = json_decode($response, true);
                    if ($bot_data['ok']) {
                        $bot_info = $bot_data['result'];
                        echo '<div class="alert alert-success">✅ توکن معتبر است! ربات: @' . $bot_info['username'] . '</div>';
                        $success[] = 'token';
                    } else {
                        $errors[] = '❌ توکن نامعتبر است!';
                        echo '<div class="alert alert-error">' . $errors[0] . '</div>';
                    }
                } else {
                    $errors[] = '❌ نمی‌توانیم به سرور تلگرام متصل شویم. لطفاً فایروال سرور را بررسی کنید.';
                    echo '<div class="alert alert-error">' . $errors[0] . '</div>';
                }
                
                // مرحله 2: تست و ساخت دیتابیس
                if (empty($errors)) {
                    echo '<div class="alert alert-info">🔍 مرحله 2: اتصال به دیتابیس...</div>';
                    
                    try {
                        $pdo = new PDO("mysql:host={$db_host}", $db_user, $db_pass);
                        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                        echo '<div class="alert alert-success">✅ اتصال به MySQL موفق</div>';
                        
                        // بررسی یا ساخت دیتابیس
                        $stmt = $pdo->query("SHOW DATABASES LIKE '{$db_name}'");
                        if ($stmt->rowCount() == 0) {
                            $pdo->exec("CREATE DATABASE `{$db_name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                            echo '<div class="alert alert-success">✅ دیتابیس ساخته شد</div>';
                        } else {
                            echo '<div class="alert alert-success">✅ دیتابیس موجود است</div>';
                        }
                        
                        // اتصال به دیتابیس
                        $pdo = new PDO("mysql:host={$db_host};dbname={$db_name};charset=utf8mb4", $db_user, $db_pass);
                        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                        
                        // ساخت جدول
                        $sql = "CREATE TABLE IF NOT EXISTS users (
                            id INT AUTO_INCREMENT PRIMARY KEY,
                            chat_id BIGINT NOT NULL UNIQUE,
                            first_name VARCHAR(255) NOT NULL,
                            active TINYINT(1) DEFAULT 1,
                            message_count INT DEFAULT 0,
                            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
                        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
                        
                        $pdo->exec($sql);
                        echo '<div class="alert alert-success">✅ جداول دیتابیس آماده شد</div>';
                        
                        $success[] = 'database';
                        
                    } catch (PDOException $e) {
                        $errors[] = '❌ خطا در دیتابیس: ' . $e->getMessage();
                        echo '<div class="alert alert-error">' . end($errors) . '</div>';
                    }
                }
                
                // مرحله 3: ساخت فایل config.php
                if (empty($errors)) {
                    echo '<div class="alert alert-info">🔍 مرحله 3: ساخت فایل تنظیمات...</div>';
                    
                    $config_content = "<?php\n";
                    $config_content .= "/**\n";
                    $config_content .= " * تنظیمات ربات تلگرام ساعت‌های جفت 🕐💕\n";
                    $config_content .= " * ساخته شده توسط نصب خودکار در " . date('Y-m-d H:i:s') . "\n";
                    $config_content .= " */\n\n";
                    $config_content .= "// توکن ربات تلگرام\n";
                    $config_content .= "define('BOT_TOKEN', '{$bot_token}');\n\n";
                    $config_content .= "// آدرس API تلگرام\n";
                    $config_content .= "define('API_URL', 'https://api.telegram.org/bot' . BOT_TOKEN . '/');\n\n";
                    $config_content .= "// مشخصات دیتابیس\n";
                    $config_content .= "define('DB_HOST', '{$db_host}');\n";
                    $config_content .= "define('DB_NAME', '{$db_name}');\n";
                    $config_content .= "define('DB_USER', '{$db_user}');\n";
                    $config_content .= "define('DB_PASS', '{$db_pass}');\n\n";
                    $config_content .= "// تنظیمات زمانی\n";
                    $config_content .= "define('TIMEZONE', 'Asia/Tehran');\n";
                    $config_content .= "date_default_timezone_set(TIMEZONE);\n\n";
                    $config_content .= "// حالت دیباگ\n";
                    $config_content .= "define('DEBUG_MODE', true);\n\n";
                    $config_content .= "/**\n";
                    $config_content .= " * لاگ پیام‌های خطا\n";
                    $config_content .= " */\n";
                    $config_content .= "function logError(\$message) {\n";
                    $config_content .= "    if (DEBUG_MODE) {\n";
                    $config_content .= "        \$logFile = __DIR__ . '/error.log';\n";
                    $config_content .= "        \$timestamp = date('Y-m-d H:i:s');\n";
                    $config_content .= "        file_put_contents(\$logFile, \"[\$timestamp] \$message\\n\", FILE_APPEND);\n";
                    $config_content .= "    }\n";
                    $config_content .= "}\n\n";
                    $config_content .= "/**\n";
                    $config_content .= " * لاگ فعالیت‌های ربات\n";
                    $config_content .= " */\n";
                    $config_content .= "function logActivity(\$message) {\n";
                    $config_content .= "    if (DEBUG_MODE) {\n";
                    $config_content .= "        \$logFile = __DIR__ . '/activity.log';\n";
                    $config_content .= "        \$timestamp = date('Y-m-d H:i:s');\n";
                    $config_content .= "        file_put_contents(\$logFile, \"[\$timestamp] \$message\\n\", FILE_APPEND);\n";
                    $config_content .= "    }\n";
                    $config_content .= "}\n";
                    
                    if (file_put_contents('config.php', $config_content)) {
                        echo '<div class="alert alert-success">✅ فایل config.php ساخته شد</div>';
                        $success[] = 'config';
                    } else {
                        $errors[] = '❌ نتوانستیم فایل config.php بسازیم';
                        echo '<div class="alert alert-error">' . end($errors) . '</div>';
                    }
                }
                
                // مرحله 4: تنظیم Webhook
                if (empty($errors)) {
                    echo '<div class="alert alert-info">🔍 مرحله 4: تنظیم Webhook...</div>';
                    
                    $webhook_url = $site_url . '/bot.php';
                    $set_webhook = "https://api.telegram.org/bot{$bot_token}/setWebhook?url=" . urlencode($webhook_url);
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $set_webhook);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    $response = curl_exec($ch);
                    curl_close($ch);
                    
                    if ($response) {
                        $webhook_data = json_decode($response, true);
                        if ($webhook_data['ok']) {
                            echo '<div class="alert alert-success">✅ Webhook تنظیم شد: ' . $webhook_url . '</div>';
                            $success[] = 'webhook';
                        } else {
                            echo '<div class="alert alert-error">⚠️ Webhook: ' . ($webhook_data['description'] ?? 'خطای نامشخص') . '</div>';
                        }
                    }
                }
                
                // مرحله 5: تنظیم خودکار Cron Job
                if (empty($errors)) {
                    echo '<div class="alert alert-info">🔍 مرحله 5: تنظیم Cron Job...</div>';
                    
                    $cron_path = __DIR__ . '/cron.php';
                    $cron_command = "* * * * * /usr/bin/php {$cron_path} >> " . __DIR__ . "/cron.log 2>&1";
                    
                    // تلاش برای نصب خودکار cron
                    $cron_installed = false;
                    
                    if (function_exists('shell_exec')) {
                        // دریافت crontab فعلی
                        $current_crontab = @shell_exec('crontab -l 2>/dev/null');
                        
                        // بررسی اینکه قبلا اضافه نشده باشد
                        if ($current_crontab === null || strpos($current_crontab, 'timebot/cron.php') === false) {
                            // اضافه کردن cron job جدید
                            $new_crontab = ($current_crontab ?? '') . "\n" . $cron_command . "\n";
                            
                            // ذخیره در فایل موقت
                            $temp_file = tempnam(sys_get_temp_dir(), 'crontab');
                            file_put_contents($temp_file, $new_crontab);
                            
                            // اعمال crontab جدید
                            $result = @shell_exec("crontab {$temp_file} 2>&1");
                            @unlink($temp_file);
                            
                            if ($result === null || strpos(strtolower($result), 'error') === false) {
                                echo '<div class="alert alert-success">✅ Cron Job به صورت خودکار نصب شد!</div>';
                                $cron_installed = true;
                            }
                        } else {
                            echo '<div class="alert alert-success">✅ Cron Job قبلاً نصب شده است</div>';
                            $cron_installed = true;
                        }
                    }
                    
                    if (!$cron_installed) {
                        echo '<div class="alert alert-error">⚠️ نتوانستیم Cron را خودکار نصب کنیم. باید دستی از cPanel اضافه کنید.</div>';
                        echo '<div class="alert alert-info">';
                        echo '<strong>دستور Cron:</strong><br>';
                        echo '<code style="background:#f0f0f0;padding:8px;display:block;margin-top:10px;direction:ltr;text-align:left;border-radius:5px;">' . $cron_command . '</code>';
                        echo '</div>';
                    }
                }
                
                // نتیجه نهایی
                if (empty($errors)) {
                    echo '<div class="alert alert-success" style="margin-top: 30px;">';
                    echo '<h3 style="margin-bottom: 15px;">🎉 نصب با موفقیت کامل شد!</h3>';
                    echo '<p><strong>ربات شما آماده است:</strong></p>';
                    echo '<ul style="margin: 15px 0 15px 25px; line-height: 2;">';
                    echo '<li>✅ توکن ربات تأیید شد</li>';
                    echo '<li>✅ دیتابیس ساخته شد</li>';
                    echo '<li>✅ Webhook تنظیم شد</li>';
                    echo '<li>' . ($cron_installed ? '✅ Cron Job نصب شد' : '⚠️ Cron Job نیاز به تنظیم دستی دارد') . '</li>';
                    echo '</ul>';
                    echo '<p style="margin-top:20px;"><strong>مراحل بعدی:</strong></p>';
                    echo '<ol style="margin: 10px 0 15px 25px; line-height: 2;">';
                    echo '<li>فایل <code>install.php</code> را <strong>حذف</strong> کنید</li>';
                    if (!$cron_installed) {
                        echo '<li>Cron Job را در cPanel تنظیم کنید (دستور بالا را کپی کنید)</li>';
                    }
                    echo '<li>به ربات @' . ($bot_info['username'] ?? '') . ' پیام <code>/start</code> بدهید</li>';
                    echo '<li>از ربات لذت ببرید! 🎊</li>';
                    echo '</ol>';
                    echo '<div style="margin-top:25px;">';
                    echo '<a href="test.php" style="display:inline-block;padding:12px 25px;background:#28a745;color:white;text-decoration:none;border-radius:10px;margin:5px;">🧪 تست ربات</a>';
                    echo '<a href="https://t.me/' . ($bot_info['username'] ?? '') . '" target="_blank" style="display:inline-block;padding:12px 25px;background:#667eea;color:white;text-decoration:none;border-radius:10px;margin:5px;">💬 باز کردن ربات</a>';
                    echo '</div>';
                    echo '</div>';
                }
            }
            ?>
        </div>
    </div>
</body>
</html>
