<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنظیم Webhook - ربات تلگرام</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 700px;
            width: 100%;
            padding: 40px;
        }
        h1 {
            color: #667eea;
            text-align: center;
            margin-bottom: 10px;
        }
        .emoji {
            text-align: center;
            font-size: 48px;
            margin-bottom: 20px;
        }
        .section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .section h3 {
            color: #333;
            margin-bottom: 15px;
        }
        .code-box {
            background: #2d3748;
            color: #48bb78;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            overflow-x: auto;
            margin: 10px 0;
            direction: ltr;
            text-align: left;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            margin: 5px;
            transition: all 0.3s;
        }
        .btn:hover {
            background: #764ba2;
            transform: translateY(-2px);
        }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
        }
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        .steps {
            counter-reset: step;
        }
        .step {
            margin: 20px 0;
            padding: 15px;
            background: white;
            border-radius: 8px;
            position: relative;
            padding-right: 50px;
        }
        .step::before {
            counter-increment: step;
            content: counter(step);
            position: absolute;
            right: 15px;
            top: 15px;
            width: 30px;
            height: 30px;
            background: #667eea;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        .step h4 {
            color: #667eea;
            margin-bottom: 10px;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            margin: 10px 0;
        }
        input[type="text"]:focus {
            outline: none;
            border-color: #667eea;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="emoji">🔧</div>
        <h1>تنظیم Webhook به صورت دستی</h1>
        <p style="text-align: center; color: #666; margin-bottom: 20px;">
            اگر نصب خودکار کار نکرد، از این روش استفاده کنید
        </p>

        <div class="alert alert-warning">
            ⚠️ <strong>نکته مهم:</strong> برای استفاده از Webhook، سایت شما باید SSL (HTTPS) داشته باشد!
        </div>

        <div class="section steps">
            <h3>📋 مراحل تنظیم:</h3>
            
            <div class="step">
                <h4>توکن ربات را آماده کنید</h4>
                <p>از @BotFather در تلگرام، توکن ربات را دریافت کنید</p>
                <input type="text" id="token" placeholder="123456:ABC-DEF1234ghIkl-zyx57W2v1u123ew11">
            </div>

            <div class="step">
                <h4>آدرس کامل Webhook را بسازید</h4>
                <p>آدرس فایل bot.php روی سرور شما:</p>
                <input type="text" id="webhook" placeholder="https://yourdomain.com/timebot/bot.php" 
                       value="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/bot.php'; ?>">
            </div>

            <div class="step">
                <h4>دستور تنظیم Webhook را بسازید</h4>
                <button class="btn" onclick="generateCommand()">🔨 ساخت دستور</button>
                <div id="result"></div>
            </div>
        </div>

        <div class="section">
            <h3>🌐 روش‌های اجرا:</h3>
            
            <h4 style="margin-top: 15px;">1️⃣ از طریق مرورگر:</h4>
            <p style="color: #666; margin: 10px 0;">دستور ساخته شده را در آدرس بار مرورگر کپی کنید</p>
            
            <h4 style="margin-top: 15px;">2️⃣ از طریق Curl (ترمینال):</h4>
            <div class="code-box" id="curlCommand"></div>
            
            <h4 style="margin-top: 15px;">3️⃣ از طریق PHP:</h4>
            <p style="color: #666; margin: 10px 0;">فایل <code>set-webhook.php</code> را از مرورگر باز کنید</p>
        </div>

        <div class="alert alert-info">
            💡 <strong>نکته:</strong> بعد از تنظیم موفق، پیام "Webhook was set" را خواهید دید
        </div>

        <div class="section">
            <h3>🔍 بررسی وضعیت Webhook:</h3>
            <button class="btn" onclick="checkWebhook()">✅ چک کردن Webhook</button>
            <div id="checkResult"></div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="install-web.php" class="btn">🔙 بازگشت به نصب خودکار</a>
            <a href="README.md" class="btn">📖 راهنما</a>
        </div>
    </div>

    <script>
        function generateCommand() {
            const token = document.getElementById('token').value.trim();
            const webhook = document.getElementById('webhook').value.trim();
            
            if (!token || !webhook) {
                alert('لطفا توکن و آدرس webhook را وارد کنید!');
                return;
            }

            const browserUrl = `https://api.telegram.org/bot${token}/setWebhook?url=${encodeURIComponent(webhook)}`;
            const curlCmd = `curl -F "url=${webhook}" https://api.telegram.org/bot${token}/setWebhook`;
            
            document.getElementById('result').innerHTML = `
                <div style="margin-top: 15px;">
                    <p style="color: #666; margin-bottom: 10px;"><strong>✅ دستور آماده شد!</strong></p>
                    <p style="color: #666; margin-bottom: 5px; font-size: 12px;">کپی و در مرورگر باز کنید:</p>
                    <div class="code-box" style="word-break: break-all;">${browserUrl}</div>
                    <button class="btn" onclick="window.open('${browserUrl}', '_blank')">🚀 باز کردن در تب جدید</button>
                </div>
            `;
            
            document.getElementById('curlCommand').textContent = curlCmd;
        }

        function checkWebhook() {
            const token = document.getElementById('token').value.trim();
            
            if (!token) {
                alert('لطفا توکن را وارد کنید!');
                return;
            }

            const checkUrl = `https://api.telegram.org/bot${token}/getWebhookInfo`;
            
            fetch(checkUrl)
                .then(response => response.json())
                .then(data => {
                    if (data.ok) {
                        const info = data.result;
                        let html = '<div style="margin-top: 15px; background: white; padding: 15px; border-radius: 8px;">';
                        html += '<h4 style="color: #667eea; margin-bottom: 10px;">📊 اطلاعات Webhook:</h4>';
                        html += `<p><strong>URL:</strong> ${info.url || 'تنظیم نشده'}</p>`;
                        html += `<p><strong>تعداد پیام‌های در انتظار:</strong> ${info.pending_update_count || 0}</p>`;
                        
                        if (info.last_error_message) {
                            html += `<p style="color: red;"><strong>آخرین خطا:</strong> ${info.last_error_message}</p>`;
                        } else {
                            html += '<p style="color: green;">✅ هیچ خطایی وجود ندارد</p>';
                        }
                        
                        html += '</div>';
                        document.getElementById('checkResult').innerHTML = html;
                    }
                })
                .catch(error => {
                    document.getElementById('checkResult').innerHTML = 
                        '<div style="margin-top: 15px; color: red;">❌ خطا در دریافت اطلاعات</div>';
                });
        }

        // تلاش برای تشخیص خودکار
        window.onload = function() {
            const webhookInput = document.getElementById('webhook');
            if (webhookInput.value) {
                console.log('آدرس Webhook تشخیص داده شد:', webhookInput.value);
            }
        };
    </script>
</body>
</html>
