<?php
/**
 * فایل تنظیم خودکار ربات - فقط یکبار اجرا کنید
 * این فایل را از مرورگر باز کنید: https://amirshasti.ir/timebot/setup.php
 */

// غیرفعال کردن نمایش خطاها برای امنیت
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';
require_once 'database.php';

/**
 * تماس با API تلگرام با پشتیبانی از curl و file_get_contents
 */
function callTelegram($method, array $params = [], $usePost = false) {
    $url = API_URL . $method;
    $queryString = !empty($params) ? http_build_query($params) : '';

    // خروجی مشترک
    $result = [
        'success' => false,
        'body' => null,
        'status' => null,
        'error' => null
    ];

    if (function_exists('curl_init')) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);

        if ($usePost) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $queryString);
        } elseif ($queryString) {
            $url .= (strpos($url, '?') === false ? '?' : '&') . $queryString;
        }

        curl_setopt($ch, CURLOPT_URL, $url);
        $response = curl_exec($ch);

        if ($response === false) {
            $result['error'] = 'curl error: ' . curl_error($ch);
        } else {
            $result['success'] = true;
            $result['body'] = $response;
            $result['status'] = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        }
        curl_close($ch);
        return $result;
    }

    if (!ini_get('allow_url_fopen')) {
        $result['error'] = 'allow_url_fopen غیرفعال است و curl هم در دسترس نیست.';
        return $result;
    }

    $contextOptions = [
        'http' => [
            'timeout' => 20,
            'ignore_errors' => true
        ]
    ];

    if ($usePost) {
        $contextOptions['http']['method'] = 'POST';
        $contextOptions['http']['header'] = "Content-type: application/x-www-form-urlencoded\r\n";
        $contextOptions['http']['content'] = $queryString;
    } elseif ($queryString) {
        $url .= (strpos($url, '?') === false ? '?' : '&') . $queryString;
    }

    $context = stream_context_create($contextOptions);
    $response = @file_get_contents($url, false, $context);

    if ($response === false) {
        $result['error'] = 'file_get_contents خطا داد یا دسترسی HTTP مسدود است.';
    } else {
        $result['success'] = true;
        $result['body'] = $response;
        if (isset($http_response_header[0])) {
            $parts = explode(' ', $http_response_header[0]);
            $result['status'] = $parts[1] ?? null;
        }
    }

    return $result;
}

$output = [];
$errors = [];
$warnings = [];
$bot_info = null;

$output[] = "ℹ️ نسخه PHP: " . PHP_VERSION;
$output[] = "ℹ️ افزونه curl: " . (function_exists('curl_version') ? 'فعال ✅' : 'غیرفعال ❌');
$output[] = "ℹ️ allow_url_fopen: " . (ini_get('allow_url_fopen') ? 'فعال ✅' : 'غیرفعال ❌');

// 1. تست توکن ربات
$output[] = "🔍 در حال تست توکن ربات...";
$testResult = callTelegram('getMe');

if (!$testResult['success']) {
    $errors[] = "❌ نمی‌توانیم به API تلگرام متصل شویم. لطفا اتصال اینترنت سرور را بررسی کنید.";
    $warnings[] = "جزئیات: " . $testResult['error'];
} else {
    $test_data = json_decode($testResult['body'], true);
    if (isset($test_data['ok']) && $test_data['ok']) {
        $bot_info = $test_data['result'];
        $output[] = "✅ توکن معتبر است!";
        $output[] = "🤖 نام ربات: " . $bot_info['first_name'];
        $output[] = "👤 یوزرنیم: @" . $bot_info['username'];
        $output[] = "🆔 شناسه ربات: " . $bot_info['id'];
    } else {
        $error_msg = $test_data['description'] ?? ('وضعیت HTTP: ' . ($testResult['status'] ?? 'نامشخص'));
        $errors[] = "❌ توکن نامعتبر یا پاسخ غیرمنتظره! جزئیات: " . $error_msg;
    }
}

// 2. تست اتصال به دیتابیس
$output[] = "\n🔍 در حال تست اتصال به دیتابیس...";
try {
    $pdo = new PDO("mysql:host=" . DB_HOST, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $output[] = "✅ اتصال به MySQL موفق!";
    
    // بررسی وجود دیتابیس
    $stmt = $pdo->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
    if ($stmt->rowCount() > 0) {
        $output[] = "✅ دیتابیس " . DB_NAME . " وجود دارد";
    } else {
        $output[] = "📝 در حال ساخت دیتابیس...";
        $pdo->exec("CREATE DATABASE " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $output[] = "✅ دیتابیس ساخته شد!";
    }
    
    // ساخت جداول
    $output[] = "📝 در حال ساخت جداول...";
    createTables();
    $output[] = "✅ جداول آماده است!";
    
} catch (PDOException $e) {
    $errors[] = "❌ خطا در دیتابیس: " . $e->getMessage();
}

// 3. تنظیم Webhook
$output[] = "\n🔍 در حال تنظیم Webhook...";
$webhook_url = "https://amirshasti.ir/timebot/bot.php";
$webhookResult = callTelegram('setWebhook', ['url' => $webhook_url], true);
$webhook_data = $webhookResult['success'] ? json_decode($webhookResult['body'], true) : null;

if ($webhook_data && isset($webhook_data['ok']) && $webhook_data['ok']) {
    $output[] = "✅ Webhook تنظیم شد!";
    $output[] = "🌐 آدرس: " . $webhook_url;
} else {
    $errorDetail = $webhook_data['description'] ?? $webhookResult['error'] ?? ('کد وضعیت: ' . ($webhookResult['status'] ?? 'نامشخص'));
    $errors[] = "❌ خطا در تنظیم Webhook: " . $errorDetail;
}

// 4. بررسی فایل cron.php
$output[] = "\n🔍 بررسی فایل cron.php...";
if (file_exists('cron.php')) {
    $output[] = "✅ فایل cron.php موجود است";
} else {
    $errors[] = "❌ فایل cron.php یافت نشد!";
}

// 5. ساخت فایل .htaccess برای cron job
$output[] = "\n🔍 در حال ساخت فایل‌های کمکی...";
$htaccess_content = "# Auto-execute cron every minute\n";
$htaccess_content .= "# این فایل برای اجرای خودکار cron نیست\n";
$htaccess_content .= "# باید از cPanel یا crontab استفاده کنید\n\n";
$htaccess_content .= "# محافظت از فایل‌های حساس\n";
$htaccess_content .= "<Files config.php>\n";
$htaccess_content .= "    Order Allow,Deny\n";
$htaccess_content .= "    Deny from all\n";
$htaccess_content .= "</Files>\n\n";
$htaccess_content .= "<Files database.php>\n";
$htaccess_content .= "    Order Allow,Deny\n";
$htaccess_content .= "    Deny from all\n";
$htaccess_content .= "</Files>\n";

if (file_put_contents('.htaccess', $htaccess_content)) {
    $output[] = "✅ فایل .htaccess ساخته شد";
} else {
    $output[] = "⚠️  نتوانستیم .htaccess بسازیم";
}

// 6. ساخت فایل cron-info.txt با اطلاعات
$cron_command = "* * * * * /usr/bin/php " . __DIR__ . "/cron.php >> " . __DIR__ . "/cron.log 2>&1";
$cron_info = "╔══════════════════════════════════════════════════════════════╗\n";
$cron_info .= "║       تنظیمات Cron Job برای ربات تلگرام ساعت‌های جفت      ║\n";
$cron_info .= "╚══════════════════════════════════════════════════════════════╝\n\n";
$cron_info .= "📋 دستور Cron Job:\n";
$cron_info .= str_repeat("-", 60) . "\n";
$cron_info .= $cron_command . "\n";
$cron_info .= str_repeat("-", 60) . "\n\n";
$cron_info .= "📝 مراحل تنظیم در cPanel:\n\n";
$cron_info .= "1. وارد cPanel شوید\n";
$cron_info .= "2. به بخش 'Cron Jobs' بروید\n";
$cron_info .= "3. در قسمت 'Add New Cron Job':\n";
$cron_info .= "   - Common Settings: Every Minute (* * * * *)\n";
$cron_info .= "   - Command: /usr/bin/php " . __DIR__ . "/cron.php\n";
$cron_info .= "4. دکمه 'Add New Cron Job' را بزنید\n\n";
$cron_info .= "✅ پس از تنظیم، ربات هر دقیقه بررسی می‌کند و در ساعت‌های\n";
$cron_info .= "   جفت (00:00, 01:01, 11:11, ...) پیام ارسال می‌کند.\n\n";
$cron_info .= "🔍 بررسی لاگ:\n";
$cron_info .= "   فایل: " . __DIR__ . "/cron.log\n\n";
$cron_info .= "📞 تست ربات:\n";
$cron_info .= "   به ربات @" . ($bot_info['username'] ?? 'your_bot') . " پیام /start بدهید\n";

file_put_contents('CRON-SETUP.txt', $cron_info);
$output[] = "✅ فایل راهنمای cron ساخته شد: CRON-SETUP.txt";

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نصب ربات - امیرحسین شاستی</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 40px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #667eea;
            font-size: 32px;
            margin-bottom: 10px;
        }
        .emoji {
            font-size: 64px;
            margin-bottom: 20px;
        }
        .output-box {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
            font-family: 'Courier New', monospace;
            font-size: 14px;
            line-height: 1.8;
            white-space: pre-wrap;
        }
        .success {
            color: #28a745;
        }
        .error {
            color: #dc3545;
            background: #f8d7da;
            padding: 15px;
            border-radius: 10px;
            margin: 10px 0;
        }
        .section {
            background: #e3f2fd;
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .section h3 {
            color: #1976d2;
            margin-bottom: 15px;
        }
        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 10px;
            margin: 10px 5px;
            transition: all 0.3s;
        }
        .btn:hover {
            background: #764ba2;
            transform: translateY(-2px);
        }
        .cron-box {
            background: #2d3748;
            color: #48bb78;
            padding: 15px;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            margin: 15px 0;
            overflow-x: auto;
            direction: ltr;
            text-align: left;
        }
        .warning {
            background: #fff3cd;
            border: 2px solid #ffc107;
            padding: 15px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .success-badge {
            background: #28a745;
            color: white;
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 12px;
            margin-right: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="emoji">🎉</div>
            <h1>نصب ربات تلگرام ساعت‌های جفت</h1>
            <p style="color: #666;">امیرحسین شاستی</p>
        </div>

        <?php if (empty($errors)): ?>
            <div style="text-align: center; padding: 20px; background: #d4edda; border-radius: 10px; margin-bottom: 20px;">
                <h2 style="color: #155724; margin-bottom: 10px;">✅ نصب با موفقیت انجام شد!</h2>
                <p style="color: #155724;">ربات آماده استفاده است</p>
            </div>
        <?php endif; ?>

        <div class="output-box">
<?php 
foreach ($output as $line) {
    echo htmlspecialchars($line) . "\n";
}
?>
        </div>

        <?php if (!empty($errors)): ?>
            <?php foreach ($errors as $error): ?>
                <div class="error">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

        <?php if (!empty($warnings)): ?>
            <?php foreach ($warnings as $warning): ?>
                <div class="warning" style="border-color:#f1b400;background:#fff8e1;">
                    ⚠️ <?php echo htmlspecialchars($warning); ?>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

        <div class="section">
            <h3>⏰ تنظیم Cron Job (مهم!)</h3>
            <p>برای ارسال خودکار پیام‌ها، باید Cron Job را تنظیم کنید:</p>
            
            <div class="cron-box"><?php echo htmlspecialchars($cron_command); ?></div>
            
            <p style="margin-top: 15px;"><strong>مراحل:</strong></p>
            <ol style="margin: 10px 20px; line-height: 2;">
                <li>وارد cPanel شوید</li>
                <li>به قسمت "Cron Jobs" بروید</li>
                <li>دستور بالا را کپی و در قسمت Command قرار دهید</li>
                <li>زمان را روی "Every Minute" تنظیم کنید</li>
            </ol>
            
            <p style="margin-top: 15px; padding: 10px; background: #fff; border-radius: 5px;">
                📄 فایل <code>CRON-SETUP.txt</code> ساخته شد با راهنمای کامل
            </p>
        </div>

        <div class="section">
            <h3>🎯 مراحل بعدی:</h3>
            <ol style="margin: 10px 20px; line-height: 2;">
                <li>به ربات در تلگرام پیام <code>/start</code> بدهید</li>
                <li>Cron Job را طبق راهنمای بالا تنظیم کنید</li>
                <li>این فایل را حذف کنید: <code>setup.php</code></li>
                <li>برای تست: <code>test.php</code> را باز کنید</li>
            </ol>
        </div>

        <?php if (isset($bot_info)): ?>
        <div style="text-align: center; margin: 30px 0;">
            <a href="https://t.me/<?php echo $bot_info['username']; ?>" target="_blank" class="btn">
                🤖 باز کردن ربات در تلگرام
            </a>
            <a href="test.php" class="btn">
                🧪 تست ربات
            </a>
        </div>
        <?php endif; ?>

        <div class="warning">
            <strong>⚠️ امنیت:</strong>
            <ul style="margin: 10px 20px;">
                <li>فایل <code>setup.php</code> را بعد از نصب حذف کنید</li>
                <li>از رمز عبور قوی برای دیتابیس استفاده کنید</li>
                <li>فایل <code>config.php</code> را در دسترس عموم قرار ندهید</li>
            </ul>
        </div>

        <div style="text-align: center; margin-top: 30px; color: #999;">
            ساخته شده با ❤️ برای امیرحسین شاستی
        </div>
    </div>
</body>
</html>
