<?php
/**
 * تست دستی Cron Job
 * این فایل را از مرورگر یا خط فرمان اجرا کنید تا ببینید cron.php کار می‌کند یا نه
 */

echo "🧪 <b>تست Cron Job</b><br><br>\n\n";
echo str_repeat("=", 60) . "<br>\n";

// 1. بررسی فایل‌های مورد نیاز
echo "<h3>📂 بررسی فایل‌ها:</h3>\n";
$required_files = ['config.php', 'database.php', 'messages.php', 'cron.php'];
foreach ($required_files as $file) {
    if (file_exists($file)) {
        echo "✅ $file موجود است<br>\n";
    } else {
        echo "❌ $file یافت نشد!<br>\n";
    }
}

echo "<br>" . str_repeat("-", 60) . "<br>\n";

// 2. بارگذاری فایل‌ها
echo "<h3>⚙️ بارگذاری ماژول‌ها:</h3>\n";
try {
    require_once 'config.php';
    echo "✅ config.php بارگذاری شد<br>\n";
    
    require_once 'database.php';
    echo "✅ database.php بارگذاری شد<br>\n";
    
    require_once 'messages.php';
    echo "✅ messages.php بارگذاری شد<br>\n";
    
} catch (Exception $e) {
    echo "❌ خطا در بارگذاری: " . $e->getMessage() . "<br>\n";
    die();
}

echo "<br>" . str_repeat("-", 60) . "<br>\n";

// 3. بررسی اتصال به دیتابیس
echo "<h3>🗄️ تست دیتابیس:</h3>\n";
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    echo "✅ اتصال به دیتابیس موفق<br>\n";
    
    // دریافت تعداد کاربران
    $stmt = $pdo->query("SELECT COUNT(*) as total FROM users");
    $total_users = $stmt->fetch()['total'];
    echo "📊 تعداد کل کاربران: $total_users<br>\n";
    
    $stmt = $pdo->query("SELECT COUNT(*) as active FROM users WHERE active = 1");
    $active_users = $stmt->fetch()['active'];
    echo "✅ کاربران فعال: $active_users<br>\n";
    
    if ($active_users == 0) {
        echo "<br>⚠️ <strong>هیچ کاربر فعالی وجود ندارد!</strong><br>\n";
        echo "💡 برای تست، به ربات پیام /start بدهید<br>\n";
    }
    
} catch (PDOException $e) {
    echo "❌ خطا در اتصال به دیتابیس: " . $e->getMessage() . "<br>\n";
}

echo "<br>" . str_repeat("-", 60) . "<br>\n";

// 4. بررسی زمان
echo "<h3>⏰ بررسی زمان:</h3>\n";
$current_time = date('H:i');
$current_hour = date('H');
$current_minute = date('i');

echo "🕐 زمان فعلی: <strong>$current_time</strong><br>\n";
echo "📅 تاریخ: " . date('Y-m-d') . "<br>\n";
echo "🌍 timezone: " . date_default_timezone_get() . "<br>\n";

// بررسی ساعت جفت
$is_matching = ($current_hour == $current_minute);
if ($is_matching) {
    echo "<br>✨ <strong style='color:green;'>الان ساعت جفت است! باید پیام ارسال شود</strong><br>\n";
} else {
    echo "<br>⏳ الان ساعت جفت نیست (ساعت: $current_hour، دقیقه: $current_minute)<br>\n";
}

// لیست ساعت‌های جفت
echo "<br>📋 ساعت‌های جفت:<br>\n";
$matching_hours = getMatchingHours();
echo implode(', ', $matching_hours) . "<br>\n";

echo "<br>" . str_repeat("-", 60) . "<br>\n";

// 5. تست ارسال پیام
echo "<h3>📤 تست ارسال پیام:</h3>\n";

if ($active_users > 0) {
    echo "🔍 در حال دریافت یک کاربر تصادفی...<br>\n";
    
    try {
        $stmt = $pdo->query("SELECT * FROM users WHERE active = 1 LIMIT 1");
        $test_user = $stmt->fetch();
        
        if ($test_user) {
            echo "👤 کاربر تست: {$test_user['first_name']} (ID: {$test_user['chat_id']})<br>\n";
            
            // دریافت پیام برای ساعت فعلی
            $test_message = getMessageForTime($current_time);
            $test_message = str_replace('{name}', $test_user['first_name'], $test_message);
            
            echo "<br>💌 <strong>پیام نمونه:</strong><br>\n";
            echo "<div style='background:#f0f0f0;padding:15px;border-radius:10px;margin:10px 0;'>";
            echo nl2br(htmlspecialchars(strip_tags($test_message)));
            echo "</div>\n";
            
            // تلاش برای ارسال واقعی (فقط در ساعت جفت)
            if ($is_matching && isset($_GET['send'])) {
                echo "<br>📮 در حال ارسال پیام واقعی...<br>\n";
                
                $url = API_URL . "sendMessage";
                $data = [
                    'chat_id' => $test_user['chat_id'],
                    'text' => $test_message,
                    'parse_mode' => 'HTML'
                ];
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                $response = curl_exec($ch);
                $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                
                if ($http_code == 200) {
                    $result = json_decode($response, true);
                    if ($result['ok']) {
                        echo "✅ پیام با موفقیت ارسال شد!<br>\n";
                    } else {
                        echo "❌ خطا در ارسال: " . ($result['description'] ?? 'نامشخص') . "<br>\n";
                    }
                } else {
                    echo "❌ خطای HTTP: $http_code<br>\n";
                }
            } else if (!$is_matching) {
                echo "<br>💡 برای ارسال واقعی، این فایل را در ساعت جفت با پارامتر ?send=1 اجرا کنید<br>\n";
                echo "مثال: <code>test-cron.php?send=1</code><br>\n";
            }
        }
        
    } catch (Exception $e) {
        echo "❌ خطا: " . $e->getMessage() . "<br>\n";
    }
} else {
    echo "⚠️ هیچ کاربر فعالی برای تست وجود ندارد<br>\n";
}

echo "<br>" . str_repeat("=", 60) . "<br>\n";

// 6. بررسی Cron Log
echo "<h3>📋 بررسی لاگ‌ها:</h3>\n";

if (file_exists('cron.log')) {
    $log_content = file_get_contents('cron.log');
    $log_lines = explode("\n", trim($log_content));
    $last_10 = array_slice($log_lines, -10);
    
    echo "📄 10 خط آخر cron.log:<br>\n";
    echo "<pre style='background:#2d2d2d;color:#0f0;padding:15px;border-radius:5px;overflow:auto;'>";
    echo htmlspecialchars(implode("\n", $last_10));
    echo "</pre>\n";
} else {
    echo "⚠️ فایل cron.log یافت نشد (احتمالاً cron هنوز اجرا نشده)<br>\n";
}

echo "<br>" . str_repeat("=", 60) . "<br>\n";

// 7. دستورالعمل Cron
echo "<h3>🔧 تنظیمات Cron Job:</h3>\n";
echo "<p>برای اجرای خودکار هر دقیقه، این دستور را در cPanel اضافه کنید:</p>\n";
echo "<pre style='background:#f0f0f0;padding:15px;border-radius:5px;direction:ltr;text-align:left;'>";
echo "* * * * * /usr/bin/php " . __DIR__ . "/cron.php >> " . __DIR__ . "/cron.log 2>&1";
echo "</pre>\n";

echo "<p><strong>یا برای تست دستی:</strong></p>\n";
echo "<pre style='background:#f0f0f0;padding:15px;border-radius:5px;direction:ltr;text-align:left;'>";
echo "php " . __DIR__ . "/cron.php";
echo "</pre>\n";

echo "<br><div style='background:#d4edda;padding:20px;border-radius:10px;border:2px solid #28a745;'>\n";
echo "<h3 style='color:#155724;margin-top:0;'>✅ چک‌لیست نهایی:</h3>\n";
echo "<ul style='color:#155724;line-height:2;'>\n";
echo "<li>✔️ همه فایل‌ها موجود باشند</li>\n";
echo "<li>✔️ اتصال به دیتابیس برقرار باشد</li>\n";
echo "<li>✔️ حداقل یک کاربر فعال وجود داشته باشد (با /start)</li>\n";
echo "<li>✔️ Cron Job در cPanel تنظیم شود</li>\n";
echo "<li>✔️ در ساعت جفت بعدی پیام ارسال خواهد شد!</li>\n";
echo "</ul>\n";
echo "</div>\n";

echo "<br><p style='text-align:center;color:#666;'>تست تمام شد! 🎉</p>\n";
?>
