<?php
/**
 * فایل تست سریع ربات
 * برای تست کارکرد توابع و ساختار پیام‌ها
 */

require_once 'config.php';
require_once 'messages.php';

echo "🧪 تست ربات ساعت‌های جفت\n";
echo "=" . str_repeat("=", 50) . "\n\n";

// تست 1: بررسی ساعت‌های جفت
echo "✅ تست 1: لیست ساعت‌های جفت\n";
$matchingHours = getMatchingHours();
echo "تعداد: " . count($matchingHours) . " ساعت\n";
echo "ساعت‌ها: " . implode(", ", $matchingHours) . "\n\n";

// تست 2: نمایش نمونه پیام برای هر ساعت
echo "✅ تست 2: نمونه پیام‌ها\n";
echo str_repeat("-", 50) . "\n\n";

foreach ($matchingHours as $time) {
    $message = getMessageForTime($time);
    // جایگزینی نام برای تست
    $message = str_replace('{name}', 'محمد', $message);
    
    echo "⏰ ساعت: $time\n";
    echo strip_tags($message) . "\n";
    echo str_repeat("-", 50) . "\n\n";
}

// تست 3: بررسی ساعت فعلی
echo "✅ تست 3: بررسی ساعت فعلی\n";
$currentTime = date('H:i');
echo "ساعت فعلی: $currentTime\n";
if (isMatchingHour($currentTime)) {
    echo "✨ الان ساعت جفته! پیام باید ارسال بشه.\n";
    $message = getMessageForTime($currentTime);
    echo "\nپیام برای الان:\n" . strip_tags(str_replace('{name}', 'کاربر', $message)) . "\n";
} else {
    echo "⏳ الان ساعت جفت نیست. منتظر می‌مونیم...\n";
    
    // محاسبه زمان تا ساعت جفت بعدی
    list($hour, $minute) = explode(':', $currentTime);
    $hour = (int)$hour;
    $minute = (int)$minute;
    
    $nextMatchingHours = [];
    foreach ($matchingHours as $mh) {
        list($mh_hour, $mh_minute) = explode(':', $mh);
        $mh_hour = (int)$mh_hour;
        if ($mh_hour > $hour || ($mh_hour == $hour && (int)$mh_minute > $minute)) {
            $nextMatchingHours[] = $mh;
        }
    }
    
    if (!empty($nextMatchingHours)) {
        echo "⏰ ساعت جفت بعدی: " . $nextMatchingHours[0] . "\n";
    } else {
        echo "⏰ ساعت جفت بعدی: " . $matchingHours[0] . " (فردا)\n";
    }
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "✨ تست‌ها با موفقیت انجام شد!\n";
